//Tablacus Explorer

//Objects
var MainWindow = window;
while (MainWindow.dialogArguments || MainWindow.opener) {
	MainWindow = MainWindow.dialogArguments || MainWindow.opener;
	if (MainWindow.MainWindow) {
		MainWindow = MainWindow.MainWindow;
	}
}
var te = MainWindow.external;
var api = te.WindowsAPI;
var fso = te.CreateObject("Scripting.FileSystemObject");
var sha = te.CreateObject("Shell.Application");
var wsh = te.CreateObject("WScript.Shell");
var wnw = te.CreateObject("WScript.Network");

var osInfo = api.Memory("OSVERSIONINFOEX");
osInfo.dwOSVersionInfoSize = osInfo.Size;
api.GetVersionEx(osInfo);

//Tablacus
Ox80000000 = api.LowPart(0x80000000);
CTRL_FV =       0;
CTRL_SB =       1;
CTRL_EB =       2;
CTRL_TE = 0x10000;
CTRL_WB = 0x20000;
CTRL_TC = 0x30000;
CTRL_TV = 0x40000;
CTRL_DT = 0x80000;

TCA_NONE   = 0;
TCA_AUTO   = 1;
TCA_TOP    = 2;
TCA_BOTTOM = 3;
TCA_LEFT   = 4;
TCA_RIGHT  = 5;

USE_TASKMEMORY = 1;

TEM_APP = 0x8000; //WM_APP
SHGDN_FORPARSINGEX = Ox80000000;
HOME_PATH = 0;//Desktop
TITLE = "Tablacus Explorer";

//Windows

MAXINT = 0x7fffffff;
MAX_PATH = 260;
INVALID_HANDLE_VALUE = -1;

S_OK           = 0;
S_FALSE        = 1;
E_NOTIMPL      = api.LowPart(0x80004001);
E_ABORT        = api.LowPart(0x80004004);
E_FAIL         = api.LowPart(0x80004005);
E_ACCESSDENIED = api.LowPart(0x80070005);

SBSP_SAMEBROWSER      = 0x0001;
SBSP_NEWBROWSER       = 0x0002;
SBSP_RELATIVE         = 0x1000;
SBSP_PARENT           = 0x2000;
SBSP_NAVIGATEBACK     = 0x4000;
SBSP_NAVIGATEFORWARD  = 0x8000;
SBSP_ACTIVATE_NOFOCUS = 0x80000;
SBSP_WRITENOHISTORY = 0x08000000;

ssfALTSTARTUP         = 0x1d;
ssfAPPDATA            = 0x1a;
ssfBITBUCKET          = 0x0a;
ssfCOMMONALTSTARTUP   = 0x1e;
ssfCOMMONAPPDATA      = 0x23;
ssfCOMMONDESKTOPDIR   = 0x19;
ssfCOMMONFAVORITES    = 0x1f;
ssfCOMMONPROGRAMS     = 0x17;
ssfCOMMONSTARTMENU    = 0x16;
ssfCOMMONSTARTUP      = 0x18;
ssfCONTROLS           = 0x03;
ssfCOOKIES            = 0x21;
ssfDESKTOP            = 0x00;
ssfDESKTOPDIRECTORY   = 0x10;
ssfDRIVES             = 0x11;
ssfFAVORITES          = 0x06;
ssfFONTS              = 0x14;
ssfHISTORY            = 0x22;
ssfINTERNETCACHE      = 0x20;
ssfLOCALAPPDATA       = 0x1c;
ssfMYPICTURES         = 0x27;
ssfNETHOOD            = 0x13;
ssfNETWORK            = 0x12;
ssfPERSONAL           = 0x05;
ssfPRINTERS           = 0x04;
ssfPRINTHOOD          = 0x1b;
ssfPROFILE            = 0x28;
ssfPROGRAMFILES       = 0x26;
ssfPROGRAMFILESx86    = 0x2a;
ssfPROGRAMS           = 0x02;
ssfRECENT             = 0x08;
ssfSENDTO             = 0x09;
ssfSTARTMENU          = 0x0b;
ssfSTARTUP            = 0x07;
ssfSYSTEM             = 0x25;
ssfSYSTEMx86          = 0x29;
ssfTEMPLATES          = 0x15;
ssfWINDOWS            = 0x24;

FVM_ICON       = 1;
FVM_SMALLICON  = 2;
FVM_LIST       = 3;
FVM_DETAILS    = 4;
FVM_THUMBNAIL  = 5;
FVM_TILE       = 6;
FVM_THUMBSTRIP = 7;

FWF_NONE                  = 0x00000000;
FWF_AUTOARRANGE           = 0x00000001;
FWF_ABBREVIATEDNAMES      = 0x00000002;
FWF_SNAPTOGRID            = 0x00000004;
FWF_OWNERDATA             = 0x00000008;
FWF_BESTFITWINDOW         = 0x00000010;
FWF_DESKTOP               = 0x00000020;
FWF_SINGLESEL             = 0x00000040;
FWF_NOSUBFOLDERS          = 0x00000080;
FWF_TRANSPARENT           = 0x00000100;
FWF_NOCLIENTEDGE          = 0x00000200;
FWF_NOSCROLL              = 0x00000400;
FWF_ALIGNLEFT             = 0x00000800;
FWF_NOICONS               = 0x00001000;
FWF_SHOWSELALWAYS         = 0x00002000;
FWF_NOVISIBLE             = 0x00004000;
FWF_SINGLECLICKACTIVATE   = 0x00008000;
FWF_NOWEBVIEW             = 0x00010000;
FWF_HIDEFILENAMES         = 0x00020000;
FWF_CHECKSELECT           = 0x00040000;
FWF_NOENUMREFRESH         = 0x00080000;
FWF_NOGROUPING            = 0x00100000;
FWF_FULLROWSELECT         = 0x00200000;
FWF_NOFILTERS             = 0x00400000;
FWF_NOCOLUMNHEADER        = 0x00800000;
FWF_NOHEADERINALLVIEWS    = 0x01000000;
FWF_EXTENDEDTILES         = 0x02000000;
FWF_TRICHECKSELECT        = 0x04000000;
FWF_AUTOCHECKSELECT       = 0x08000000;
FWF_NOBROWSERVIEWSTATE    = 0x10000000;
FWF_SUBSETGROUPS          = 0x20000000;
FWF_USESEARCHFOLDER       = 0x40000000;
FWF_ALLOWRTLREADING       = Ox80000000;

EBO_NONE                 = 0x0000;
EBO_NAVIGATEONCE         = 0x0001;
EBO_SHOWFRAMES           = 0x0002;
EBO_ALWAYSNAVIGATE       = 0x0004;
EBO_NOWRAPPERWINDOW      = 0x0010;
EBO_HTMLSHAREPOINTVIEW   = 0x0020;

SVSI_DESELECT       = 0x00000000;
SVSI_SELECT         = 0x00000001;
SVSI_EDIT           = 0x00000003;
SVSI_DESELECTOTHERS = 0x00000004;
SVSI_ENSUREVISIBLE  = 0x00000008;
SVSI_FOCUSED        = 0x00000010;
SVSI_TRANSLATEPT    = 0x00000020;
SVSI_SELECTIONMARK  = 0x00000040;
SVSI_POSITIONITEM   = 0x00000080;
SVSI_CHECK          = 0x00000100;
SVSI_CHECK2         = 0x00000200;
SVSI_KEYBOARDSELECT = 0x00000401;
SVSI_NOTAKEFOCUS    = 0x40000000;
SVSI_NOSTATECHANGE  = Ox80000000;

EPS_DONTCARE = 0;
EPS_DEFAULT_ON = 1;
EPS_DEFAULT_OFF = 2;
EPS_STATEMASK = 0xffff;
EPS_INITIALSTATE = 0x10000;
EPS_FORCE = 0x20000;

EP_NavPane           = '{CB316B22-25F7-42B8-8A09-540D23A43C2F}';
EP_Commands          = '{D9745868-CA5F-4A76-91CD-F5A129FBB076}';
EP_PreviewPane       = '{893C63D1-45C8-4D17-BE19-223BE71BE365}';
EP_Commands_View     = '{21F7C32D-EEAA-439B-BB51-37B96FD6A943}';
EP_Commands_Organize = '{72E81700-E3EC-4660-BF24-3C3B7B648806}';

VK_LBUTTON  = 0x01;
VK_RBUTTON  = 0x02;
VK_CANCEL   = 0x03;
VK_MBUTTON  = 0x04;
VK_XBUTTON1 = 0x05;
VK_XBUTTON2 = 0x06;
VK_BACK     = 0x08;
VK_TAB      = 0x09;
VK_CLEAR    = 0x0C;
VK_RETURN   = 0x0D;
VK_SHIFT    = 0x10;
VK_CONTROL  = 0x11;
VK_MENU     = 0x12;
VK_CAPITAL  = 0x14;
VK_ESCAPE   = 0x1B;
VK_SPACE    = 0x20;
VK_PRIOR    = 0x21;
VK_NEXT     = 0x22;
VK_END      = 0x23;
VK_HOME     = 0x24;
VK_LEFT     = 0x25;
VK_UP       = 0x26;
VK_RIGHT    = 0x27;
VK_DOWN     = 0x28;
VK_SELECT   = 0x29;
VK_PRINT    = 0x2A;
VK_EXECUTE  = 0x2B;
VK_SNAPSHOT = 0x2C;
VK_INSERT   = 0x2D;
VK_DELETE   = 0x2E;
VK_HELP     = 0x2F;
VK_LWIN     = 0x5B;
VK_RWIN     = 0x5C;
VK_APPS     = 0x5D;
VK_F1       = 0x70;
VK_F2       = 0x71;
VK_F3       = 0x72;
VK_F4       = 0x73;
VK_F5       = 0x74;
VK_F6       = 0x75;
VK_F7       = 0x76;
VK_F8       = 0x77;
VK_F9       = 0x78;
VK_F10      = 0x79;
VK_F11      = 0x7A;
VK_F12      = 0x7B;

MK_LBUTTON  = 1;
MK_RBUTTON  = 2;
MK_SHIFT    = 4;
MK_CONTROL  = 8;
MK_MBUTTON  = 0x10;
MK_XBUTTON1 = 0x20;
MK_XBUTTON2 = 0x40;

XBUTTON1 = 1;
XBUTTON2 = 2;

DROPEFFECT_NONE = 0;
DROPEFFECT_COPY = 1;
DROPEFFECT_MOVE = 2;
DROPEFFECT_LINK = 4;

WM_NULL            = 0x0000;
WM_CREATE          = 0x0001;
WM_DESTROY         = 0x0002;
WM_MOVE            = 0x0003;
WM_SIZE            = 0x0005;
WM_ACTIVATE        = 0x0006;
WM_SETFOCUS        = 0x0007;
WM_KILLFOCUS       = 0x0008;
WM_ENABLE          = 0x000A;
WM_SETREDRAW       = 0x000B;
WM_SETTEXT         = 0x000C;
WM_GETTEXT         = 0x000D;
WM_GETTEXTLENGTH   = 0x000E;
WM_PAINT           = 0x000F;
WM_CLOSE           = 0x0010;
WM_QUERYENDSESSION = 0x0011;
WM_QUERYOPEN       = 0x0013;
WM_ENDSESSION      = 0x0016;
WM_QUIT            = 0x0012;
WM_ERASEBKGND      = 0x0014;
WM_SYSCOLORCHANGE  = 0x0015;
WM_SHOWWINDOW      = 0x0018;
WM_WININICHANGE    = 0x001A;
WM_SETTINGCHANGE   = WM_WININICHANGE;
WM_DEVMODECHANGE   = 0x001B;
WM_ACTIVATEAPP     = 0x001C;
WM_FONTCHANGE      = 0x001D;
WM_TIMECHANGE      = 0x001E;
WM_CANCELMODE      = 0x001F;
WM_SETCURSOR       = 0x0020;
WM_MOUSEACTIVATE   = 0x0021;
WM_CHILDACTIVATE   = 0x0022;
WM_QUEUESYNC       = 0x0023;
WM_GETMINMAXINFO   = 0x0024;
WM_SETFONT         = 0x0030;
WM_GETFONT         = 0x0031;
WM_COPYDATA        = 0x004A;
WM_NOTIFY          = 0x004E;
WM_CONTEXTMENU     = 0x007B;
WM_GETICON         = 0x007F;
WM_SETICON         = 0x0080;
WM_KEYDOWN         = 0x0100;
WM_KEYUP           = 0x0101;
WM_CHAR            = 0x0102;
WM_DEADCHAR        = 0x0103;
WM_SYSKEYDOWN      = 0x0104;
WM_SYSKEYUP        = 0x0105;
WM_SYSCHAR         = 0x0106;
WM_SYSDEADCHAR     = 0x0107;
WM_UNICHAR         = 0x0109;
WM_INITDIALOG      = 0x0110;
WM_COMMAND         = 0x0111;
WM_SYSCOMMAND      = 0x0112;
WM_TIMER           = 0x0113;
WM_HSCROLL         = 0x0114;
WM_VSCROLL         = 0x0115;
WM_INITMENU        = 0x0116;
WM_INITMENUPOPUP   = 0x0117;
WM_MENUSELECT      = 0x011F;
WM_MENUCHAR        = 0x0120;
WM_MENURBUTTONUP   = 0x0122;
WM_MENUDRAG        = 0x0123;
WM_MENUGETOBJECT   = 0x0124;
WM_UNINITMENUPOPUP = 0x0125;
WM_MENUCOMMAND     = 0x0126;

WM_MOUSEMOVE      = 0x0200;
WM_LBUTTONDOWN    = 0x0201;
WM_LBUTTONUP      = 0x0202;
WM_LBUTTONDBLCLK  = 0x0203;
WM_RBUTTONDOWN    = 0x0204;
WM_RBUTTONUP      = 0x0205;
WM_RBUTTONDBLCLK  = 0x0206;
WM_MBUTTONDOWN    = 0x0207;
WM_MBUTTONUP      = 0x0208;
WM_MBUTTONDBLCLK  = 0x0209;
WM_MOUSEWHEEL     = 0x020A;
WM_XBUTTONDOWN    = 0x020B;
WM_XBUTTONUP      = 0x020C;
WM_XBUTTONDBLCLK  = 0x020D;
WM_PARENTNOTIFY   = 0x0210;
WM_ENTERMENULOOP  = 0x0211;
WM_EXITMENULOOP   = 0x0212;
WM_POWERBROADCAST = 0x0218;
WM_DEVICECHANGE   = 0x0219;
WM_DROPFILES      = 0x0233;

WM_USER           = 0x0400;
WM_APP            = 0x8000;

TCHT_NOWHERE     = 0x0001;
TCHT_ONITEMICON  = 0x0002;
TCHT_ONITEMLABEL = 0x0004;
TCHT_ONITEM      = 0x0006;

TCM_DELETEALLITEMS = 0x1309;
TCM_DELETEITEM     = 0x1308;
TCM_GETCURSEL      = 0x130B;
TCM_GETITEMCOUNT   = 0x1304;
TCM_INSERTITEM     = 0x1307;
TCM_SETCURSEL      = 0x130C;
TCM_SETIMAGELIST   = 0x1303;
TCM_SETITEM        = 0x133d;
TCM_GETITEM        = 0x133c;
TCM_SETMINTABWIDTH = 0x1331;

TCIF_TEXT       = 0x0001;
TCIF_IMAGE      = 0x0002;
TCIF_RTLREADING = 0x0004;
TCIF_PARAM      = 0x0008;
TCIF_STATE      = 0x0010;

WC_LISTVIEW   = "SysListView32";
WC_TREEVIEW   = "SysTreeView32";
WC_TABCONTROL = "SysTabControl32";
WC_HEADER     = "SysHeader32";
WC_EDIT       = "Edit";

LVM_FINDITEM           = 0x100D;
LVM_GETBKCOLOR         = 0x1000;
LVM_GETBKIMAGE         = 0x108B;
LVM_GETCOUNTPERPAGE    = 0x1028;
LVM_GETEXTENDEDLISTVIEWSTYLE = 0x1037;
LVM_GETGROUPCOUNT      = 0x1098;
LVM_GETGROUPINFO       = 0x1095;
LVM_GETHEADER          = 0x101F;
LVM_GETITEM            = 0x1005;
LVM_GETITEMCOUNT       = 0x1004;
LVM_GETITEMPOSITION    = 0x1010;
LVM_GETITEMRECT        = 0x100E;
LVM_GETITEMSTATE       = 0x102C;
LVM_GETNEXTITEM        = 0x100C;
LVM_GETORIGIN          = 0x1029;
LVM_GETSELECTEDCOLUMN  = 0x10AE;
LVM_GETSTRINGWIDTH     = 0x1057;
LVM_GETTEXTCOLOR       = 0x1023;
LVM_GETTEXTBKCOLOR     = 0x1025;
LVM_GETTOPINDEX        = 0x1027;
LVM_HASGROUP           = 0x10A1;
LVM_HITTEST            = 0x1012;
LVM_ISITEMVISIBLE      = 0x10B6;
LVM_ISGROUPVIEWENABLED = 0x10B2;
LVM_REDRAWITEMS        = 0x1015;
LVM_SCROLL             = 0x1014;
LVM_SETBKCOLOR         = 0x1001;
LVM_SETBKIMAGE         = 0x108A;
LVM_SETEXTENDEDLISTVIEWSTYLE = 0x1036;
LVM_SETGROUPINFO       = 0x1093;
LVM_SETITEM            = 0x1006;
LVM_SETITEMPOSITION32  = 0x1031;
LVM_SETITEMSTATE       = 0x102B;
LVM_SETSELECTEDCOLUMN  = 0x108C;
LVM_SETTEXTBKCOLOR     = 0x1026;
LVM_SETTEXTCOLOR       = 0x1024;

LVIF_TEXT        = 0x00000001;
LVIF_IMAGE       = 0x00000002;
LVIF_PARAM       = 0x00000004;
LVIF_STATE       = 0x00000008;
LVIF_INDENT      = 0x00000010;
LVIF_NORECOMPUTE = 0x00000800;
LVIF_GROUPID     = 0x00000100;
LVIF_COLUMNS     = 0x00000200;
LVIF_COLFMT      = 0x00010000;

LVIS_FOCUSED     = 0x0001;
LVIS_SELECTED    = 0x0002;
LVIS_CUT         = 0x0004;
LVIS_DROPHILITED = 0x0008;
LVIS_GLOW        = 0x0010;
LVIS_ACTIVATING  = 0x0020;
LVIS_OVERLAYMASK = 0x0F00;
LVIS_STATEIMAGEMASK = 0xF000;

LVFI_PARAM     = 0x0001;
LVFI_STRING    = 0x0002;
LVFI_SUBSTRING = 0x0004;
LVFI_PARTIAL   = 0x0008;
LVFI_WRAP      = 0x0020;
LVFI_NEARESTXY = 0x0040;

LVS_EX_GRIDLINES        = 0x00000001;
LVS_EX_SUBITEMIMAGES    = 0x00000002;
LVS_EX_CHECKBOXES       = 0x00000004;
LVS_EX_TRACKSELECT      = 0x00000008;
LVS_EX_HEADERDRAGDROP   = 0x00000010;
LVS_EX_FULLROWSELECT    = 0x00000020;
LVS_EX_ONECLICKACTIVATE = 0x00000040;
LVS_EX_TWOCLICKACTIVATE = 0x00000080;
LVS_EX_FLATSB           = 0x00000100;
LVS_EX_REGIONAL         = 0x00000200;
LVS_EX_INFOTIP          = 0x00000400;
LVS_EX_UNDERLINEHOT     = 0x00000800;
LVS_EX_UNDERLINECOLD    = 0x00001000;
LVS_EX_MULTIWORKAREAS   = 0x00002000;
LVS_EX_LABELTIP         = 0x00004000;
LVS_EX_BORDERSELECT     = 0x00008000;
LVS_EX_DOUBLEBUFFER     = 0x00010000;
LVS_EX_HIDELABELS       = 0x00020000;
LVS_EX_SINGLEROW        = 0x00040000;
LVS_EX_SNAPTOGRID       = 0x00080000;
LVS_EX_SIMPLESELECT     = 0x00100000;
LVS_EX_JUSTIFYCOLUMNS   = 0x00200000;
LVS_EX_TRANSPARENTBKGND = 0x00400000;
LVS_EX_TRANSPARENTSHADOWTEXT = 0x00800000;
LVS_EX_AUTOAUTOARRANGE  = 0x01000000;
LVS_EX_HEADERINALLVIEWS = 0x02000000;
LVS_EX_AUTOCHECKSELECT  = 0x08000000;
LVS_EX_AUTOSIZECOLUMNS  = 0x10000000;
LVS_EX_COLUMNSNAPPOINTS = 0x40000000;
LVS_EX_COLUMNOVERFLOW   = Ox80000000;

LVBKIF_SOURCE_NONE      = 0x00000000;
LVBKIF_SOURCE_HBITMAP   = 0x00000001;
LVBKIF_SOURCE_URL       = 0x00000002;
LVBKIF_SOURCE_MASK      = 0x00000003;
LVBKIF_STYLE_NORMAL     = 0x00000000;
LVBKIF_STYLE_TILE       = 0x00000010;
LVBKIF_STYLE_MASK       = 0x00000010;
LVBKIF_FLAG_TILEOFFSET  = 0x00000100;
LVBKIF_TYPE_WATERMARK   = 0x10000000;
LVBKIF_FLAG_ALPHABLEND  = 0x20000000;

LVIR_BOUNDS       = 0;
LVIR_ICON         = 1;
LVIR_LABEL        = 2;
LVIR_SELECTBOUNDS = 3;

LVNI_ALL           = 0x0000;
LVNI_FOCUSED       = 0x0001;
LVNI_SELECTED      = 0x0002;
LVNI_CUT           = 0x0004;
LVNI_DROPHILITED   = 0x0008;
LVNI_STATEMASK     = (LVNI_FOCUSED | LVNI_SELECTED | LVNI_CUT | LVNI_DROPHILITED);
LVNI_VISIBLEORDER  = 0x0010;
LVNI_PREVIOUS      = 0x0020;
LVNI_VISIBLEONLY   = 0x0040;
LVNI_SAMEGROUPONLY = 0x0080;
LVNI_ABOVE         = 0x0100;
LVNI_BELOW         = 0x0200;
LVNI_TOLEFT        = 0x0400;
LVNI_TORIGHT       = 0x0800;
LVNI_DIRECTIONMASK = (LVNI_ABOVE | LVNI_BELOW | LVNI_TOLEFT | LVNI_TORIGHT);

TVM_CREATEDRAGIMAGE  = 0x1112;
TVM_DELETEITEM       = 0x1101;
TVM_ENDEDITLABELNO   = 0x1116;
TVM_ENSUREVISIBLE    = 0x1114;
TVM_EXPAND           = 0x1102;
TVM_GETCOUNT         = 0x1105;
TVM_GETEDITCONTROL   = 0x110f;
TVM_GETIMAGELIST     = 0x1108;
TVM_GETINDENT        = 0x1106;
TVM_GETITEMRECT      = 0x1104;
TVM_GETNEXTITEM      = 0x110a;
TVM_GETVISIBLECOUNT  = 0x1110;
TVM_HITTEST          = 0x1111;
TVM_EDITLABEL        = 0x1141;
TVM_GETISEARCHSTRING = 0x1140;
TVM_GETITEM          = 0x113e;
TVM_INSERTITEM       = 0x1132;
TVM_SETITEM          = 0x113f;
TVM_SELECTITEM       = 0x110b;
TVM_SETIMAGELIST     = 0x1109;
TVM_SETINDENT        = 0x1107;
TVM_SORTCHILDREN     = 0x1113;
TVM_SORTCHILDRENCB   = 0x1115;

TVIF_TEXT          = 0x0001;
TVIF_IMAGE         = 0x0002;
TVIF_PARAM         = 0x0004;
TVIF_STATE         = 0x0008;
TVIF_HANDLE        = 0x0010;
TVIF_SELECTEDIMAGE = 0x0020;
TVIF_CHILDREN      = 0x0040;
TVIF_INTEGRAL      = 0x0080;
TVIF_STATEEX       = 0x0100;
TVIF_EXPANDEDIMAGE = 0x0200;

TVIS_SELECTED       = 0x0002;
TVIS_CUT            = 0x0004;
TVIS_DROPHILITED    = 0x0008;
TVIS_BOLD           = 0x0010;
TVIS_EXPANDED       = 0x0020;
TVIS_EXPANDEDONCE   = 0x0040;
TVIS_EXPANDPARTIAL  = 0x0080;
TVIS_OVERLAYMASK    = 0x0F00;
TVIS_STATEIMAGEMASK = 0xF000;
TVIS_USERMASK       = 0xF000;
TVIS_EX_FLAT        = 0x0001;
TVIS_EX_DISABLED    = 0x0002;
TVIS_EX_ALL         = 0x0002;

MF_INSERT          = 0x0000;
MF_CHANGE          = 0x0080;
MF_APPEND          = 0x0100;
MF_DELETE          = 0x0200;
MF_REMOVE          = 0x1000;
MF_BYCOMMAND       = 0x0000;
MF_BYPOSITION      = 0x0400;
MF_SEPARATOR       = 0x0800;
MF_ENABLED         = 0x0000;
MF_GRAYED          = 0x0001;
MF_DISABLED        = 0x0002;
MF_UNCHECKED       = 0x0000;
MF_CHECKED         = 0x0008;
MF_USECHECKBITMAPS = 0x0200;
MF_STRING          = 0x0000;
MF_BITMAP          = 0x0004;
MF_OWNERDRAW       = 0x0100;
MF_POPUP           = 0x0010;
MF_MENUBARBREAK    = 0x0020;
MF_MENUBREAK       = 0x0040;
MF_UNHILITE        = 0x0000;
MF_HILITE          = 0x0080;
MF_DEFAULT         = 0x1000;
MF_SYSMENU         = 0x2000;
MF_HELP            = 0x4000;
MF_RIGHTJUSTIFY    = 0x4000;
MF_MOUSESELECT     = 0x8000;

MFT_STRING       = MF_STRING;
MFT_BITMAP       = MF_BITMAP;
MFT_MENUBARBREAK = MF_MENUBARBREAK;
MFT_MENUBREAK    = MF_MENUBREAK;
MFT_OWNERDRAW    = MF_OWNERDRAW;
MFT_RADIOCHECK   = 0x00000200;
MFT_SEPARATOR    = MF_SEPARATOR;
MFT_RIGHTORDER   = 0x00002000;
MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY;

MFS_GRAYED    = 0x00000003;
MFS_DISABLED  = MFS_GRAYED;
MFS_CHECKED   = MF_CHECKED;
MFS_HILITE    = MF_HILITE;
MFS_ENABLED   = MF_ENABLED;
MFS_UNCHECKED = MF_UNCHECKED;
MFS_UNHILITE  = MF_UNHILITE;
MFS_DEFAULT   = MF_DEFAULT;

GMDI_USEDISABLED  = 0x0001;
GMDI_GOINTOPOPUPS = 0x0002;

TPM_LEFTBUTTON      = 0x0000;
TPM_RIGHTBUTTON     = 0x0002;
TPM_LEFTALIGN       = 0x0000;
TPM_CENTERALIGN     = 0x0004;
TPM_RIGHTALIGN      = 0x0008;
TPM_TOPALIGN        = 0x0000;
TPM_VCENTERALIGN    = 0x0010;
TPM_BOTTOMALIGN     = 0x0020;
TPM_HORIZONTAL      = 0x0000;
TPM_VERTICAL        = 0x0040;
TPM_NONOTIFY        = 0x0080;
TPM_RETURNCMD       = 0x0100;
TPM_RECURSE         = 0x0001;
TPM_HORPOSANIMATION = 0x0400;
TPM_HORNEGANIMATION = 0x0800;
TPM_VERPOSANIMATION = 0x1000;
TPM_VERNEGANIMATION = 0x2000;
TPM_NOANIMATION     = 0x4000;

CMF_NORMAL        = 0x0000;
CMF_DEFAULTONLY   = 0x0001;
CMF_VERBSONLY     = 0x0002;
CMF_EXPLORE       = 0x0004;
CMF_NOVERBS       = 0x0008;
CMF_CANRENAME     = 0x0010;
CMF_NODEFAULT     = 0x0020;
CMF_INCLUDESTATIC = 0x0040;
CMF_ITEMMENU      = 0x0080;
CMF_EXTENDEDVERBS = 0x0100;
CMF_DISABLEDVERBS = 0x0200;

SW_HIDE            = 0
SW_SHOWNORMAL      = 1
SW_NORMAL          = 1
SW_SHOWMINIMIZED   = 2
SW_SHOWMAXIMIZED   = 3
SW_MAXIMIZE        = 3
SW_SHOWNOACTIVATE  = 4
SW_SHOW            = 5
SW_MINIMIZE        = 6
SW_SHOWMINNOACTIVE = 7
SW_SHOWNA          = 8
SW_RESTORE         = 9
SW_SHOWDEFAULT     = 10
SW_FORCEMINIMIZE   = 11

LOAD_LIBRARY_AS_DATAFILE = 0x0002;
IMAGE_BITMAP = 0;
IMAGE_ICON = 1;
IMAGE_CURSOR = 2;
IMAGE_ENHMETAFILE = 3;

LR_DEFAULTCOLOR     = 0x0000;
LR_MONOCHROME       = 0x0001;
LR_COLOR            = 0x0002;
LR_LOADFROMFILE     = 0x0010;
LR_LOADTRANSPARENT  = 0x0020;
LR_CREATEDIBSECTION = 0x2000;
LR_COPYFROMRESOURCE = 0x4000;
LR_SHARED           = 0x8000;

CLR_NONE    = 0xFFFFFFFF;
CLR_DEFAULT = 0xFF000000;

COLOR_SCROLLBAR         = 0;
COLOR_BACKGROUND        = 1;
COLOR_ACTIVECAPTION     = 2;
COLOR_INACTIVECAPTION   = 3;
COLOR_MENU              = 4;
COLOR_WINDOW            = 5;
COLOR_WINDOWFRAME       = 6;
COLOR_MENUTEXT          = 7;
COLOR_WINDOWTEXT        = 8;
COLOR_CAPTIONTEXT       = 9;
COLOR_ACTIVEBORDER      = 10;
COLOR_INACTIVEBORDER    = 11;
COLOR_APPWORKSPACE      = 12;
COLOR_HIGHLIGHT         = 13;
COLOR_HIGHLIGHTTEXT     = 14;
COLOR_BTNFACE           = 15;
COLOR_BTNSHADOW         = 16;
COLOR_GRAYTEXT          = 17;
COLOR_BTNTEXT           = 18;
COLOR_INACTIVECAPTIONTEXT = 19;
COLOR_BTNHIGHLIGHT      = 20;

ILD_NORMAL      = 0x00000000;
ILD_TRANSPARENT = 0x00000001;
ILD_MASK        = 0x00000010;
ILD_IMAGE       = 0x00000020;

WS_BORDER = 0x00800000;

TCS_TABS              = 0x0000;
TCS_BUTTONS           = 0x0100;
TCS_SINGLELINE        = 0x0000;
TCS_MULTILINE         = 0x0200;
TCS_RIGHTJUSTIFY      = 0x0000;
TCS_FIXEDWIDTH        = 0x0400;
TCS_RAGGEDRIGHT       = 0x0800;
TCS_FOCUSONBUTTONDOWN = 0x1000;
TCS_OWNERDRAWFIXED    = 0x2000;
TCS_TOOLTIPS          = 0x4000;
TCS_FOCUSNEVER        = 0x8000;
TCS_SCROLLOPPOSITE    = 0x0001;
TCS_BOTTOM            = 0x0002;
TCS_RIGHT             = 0x0002;
TCS_MULTISELECT       = 0x0004;
TCS_FLATBUTTONS       = 0x0008;
TCS_FORCEICONLEFT     = 0x0010;
TCS_FORCELABELLEFT    = 0x0020;
TCS_HOTTRACK          = 0x0040;
TCS_VERTICAL          = 0x0080;

NSTCS_HASEXPANDOS         = 1;
NSTCS_HASLINES            = 2;
NSTCS_SINGLECLICKEXPAND   = 4;
NSTCS_FULLROWSELECT       = 8;
NSTCS_SPRINGEXPAND        = 0x10;
NSTCS_HORIZONTALSCROLL    = 0x20;
NSTCS_ROOTHASEXPANDO      = 0x40;
NSTCS_SHOWSELECTIONALWAYS = 0x80;
NSTCS_NOINFOTIP           = 0x200;
NSTCS_EVENHEIGHT          = 0x400;
NSTCS_NOREPLACEOPEN       = 0x800;
NSTCS_DISABLEDRAGDROP     = 0x1000;
NSTCS_NOORDERSTREAM       = 0x2000;
NSTCS_RICHTOOLTIP         = 0x4000;
NSTCS_BORDER              = 0x8000;
NSTCS_NOEDITLABELS        = 0x10000;
NSTCS_TABSTOP             = 0x20000;
NSTCS_FAVORITESMODE       = 0x80000;
NSTCS_AUTOHSCROLL         = 0x100000;
NSTCS_FADEINOUTEXPANDOS   = 0x200000;
NSTCS_EMPTYTEXT           = 0x400000;
NSTCS_CHECKBOXES          = 0x800000;
NSTCS_PARTIALCHECKBOXES   = 0x1000000;
NSTCS_EXCLUSIONCHECKBOXES = 0x2000000;
NSTCS_DIMMEDCHECKBOXES    = 0x4000000;
NSTCS_NOINDENTCHECKS      = 0x8000000;
NSTCS_ALLOWJUNCTIONS      = 0x10000000;
NSTCS_SHOWTABSBUTTON      = 0x20000000;
NSTCS_SHOWDELETEBUTTON    = 0x40000000;
NSTCS_SHOWREFRESHBUTTON   = Ox80000000;

SHGDN_NORMAL        = 0;
SHGDN_INFOLDER      = 1;
SHGDN_FOREDITING    = 0x1000;
SHGDN_FORADDRESSBAR = 0x4000;
SHGDN_FORPARSING    = 0x8000;

SHCONTF_CHECKING_FOR_CHILDREN = 0x00010;
SHCONTF_FOLDERS               = 0x00020;
SHCONTF_NONFOLDERS            = 0x00040;
SHCONTF_INCLUDEHIDDEN         = 0x00080;
SHCONTF_INIT_ON_FIRST_NEXT    = 0x00100;
SHCONTF_NETPRINTERSRCH        = 0x00200;
SHCONTF_SHAREABLE             = 0x00400;
SHCONTF_STORAGE               = 0x00800;
SHCONTF_NAVIGATION_ENUM       = 0x01000;
SHCONTF_FASTITEMS             = 0x02000;
SHCONTF_FLATLIST              = 0x04000;
SHCONTF_ENABLE_ASYNC          = 0x08000;
SHCONTF_INCLUDESUPERHIDDEN    = 0x10000;

SHGDFIL_FINDDATA      = 1;
SHGDFIL_NETRESOURCE   = 2;
SHGDFIL_DESCRIPTIONID = 3;

NSTCRS_VISIBLE  = 0x0000;
NSTCRS_HIDDEN   = 0x0001;
NSTCRS_EXPANDED = 0x0002;

NSTCEHT_NOWHERE         = 0x0001;
NSTCEHT_ONITEMICON      = 0x0002;
NSTCEHT_ONITEMLABEL     = 0x0004;
NSTCEHT_ONITEMINDENT    = 0x0008;
NSTCEHT_ONITEMBUTTON    = 0x0010;
NSTCEHT_ONITEMRIGHT     = 0x0020;
NSTCEHT_ONITEMSTATEICON = 0x0040;
NSTCEHT_ONITEM          = 0x0046;
NSTCEHT_ONITEMTABBUTTON = 0x1000;

NSTCECT_LBUTTON  = 0x0001;
NSTCECT_MBUTTON  = 0x0002;
NSTCECT_RBUTTON  = 0x0003;
NSTCECT_BUTTON   = 0x0003;
NSTCECT_DBLCLICK = 0x0004;

LVHT_NOWHERE         = 0x0001;
LVHT_ONITEMICON      = 0x0002;
LVHT_ONITEMLABEL     = 0x0004;
LVHT_ONITEMSTATEICON = 0x0008;
LVHT_ONITEM          = (LVHT_ONITEMICON | LVHT_ONITEMLABEL | LVHT_ONITEMSTATEICON);

LVHT_ABOVE           = 0x0008;
LVHT_BELOW           = 0x0010;
LVHT_TORIGHT         = 0x0020;
LVHT_TOLEFT          = 0x0040;

TVHT_NOWHERE         = 0x0001;
TVHT_ONITEMICON      = 0x0002;
TVHT_ONITEMLABEL     = 0x0004;
TVHT_ONITEMINDENT    = 0x0008;
TVHT_ONITEMBUTTON    = 0x0010;
TVHT_ONITEMRIGHT     = 0x0020;
TVHT_ONITEMSTATEICON = 0x0040;
TVHT_ONITEM          = (TVHT_ONITEMICON | TVHT_ONITEMLABEL | TVHT_ONITEMSTATEICON);

TVHT_ABOVE           = 0x0100;
TVHT_BELOW           = 0x0200;
TVHT_TORIGHT         = 0x0400;
TVHT_TOLEFT          = 0x0800;

WHITE_BRUSH         = 0;
LTGRAY_BRUSH        = 1;
GRAY_BRUSH          = 2;
DKGRAY_BRUSH        = 3;
BLACK_BRUSH         = 4;
NULL_BRUSH          = 5;
HOLLOW_BRUSH        = NULL_BRUSH;
WHITE_PEN           = 6;
BLACK_PEN           = 7;
NULL_PEN            = 8;
OEM_FIXED_FONT      = 10;
ANSI_FIXED_FONT     = 11;
ANSI_VAR_FONT       = 12;
SYSTEM_FONT         = 13;
DEVICE_DEFAULT_FONT = 14;
DEFAULT_PALETTE     = 15;
SYSTEM_FIXED_FONT   = 16;
DEFAULT_GUI_FONT    = 17;
DC_BRUSH            = 18;
DC_PEN              = 19;

VT_EMPTY   = 0;
VT_NULL    = 1;
VT_I1      = 16;
VT_I2      = 2;
VT_I4      = 3;
VT_I8      = 20;
VT_UI1     = 17;
VT_UI2     = 18;
VT_UI4     = 19;
VT_UI8     = 21;
VT_R4      = 4;
VT_R8      = 5;
VT_BSTR    = 8;
VT_LPSTR   = 30;
VT_LPWSTR  = 31;
VT_PTR     = 26;
VT_VARIANT = 12;
VT_ARRAY   = 0x2000;

FO_MOVE   = 0x0001;
FO_COPY   = 0x0002;
FO_DELETE = 0x0003;
FO_RENAME = 0x0004;

FOF_MULTIDESTFILES        = 0x0001;
FOF_CONFIRMMOUSE          = 0x0002;
FOF_SILENT                = 0x0004;
FOF_RENAMEONCOLLISION     = 0x0008;
FOF_NOCONFIRMATION        = 0x0010;
FOF_WANTMAPPINGHANDLE     = 0x0020;
FOF_ALLOWUNDO             = 0x0040;
FOF_FILESONLY             = 0x0080;
FOF_SIMPLEPROGRESS        = 0x0100;
FOF_NOCONFIRMMKDIR        = 0x0200;
FOF_NOERRORUI             = 0x0400;
FOF_NOCOPYSECURITYATTRIBS = 0x0800;
FOF_NORECURSION           = 0x1000;
FOF_NO_CONNECTED_ELEMENTS = 0x2000;
FOF_WANTNUKEWARNING       = 0x4000;
FOF_NORECURSEREPARSE      = 0x8000;

SM_CYSCREEN      = 1;
SM_CXVSCROLL     = 2;
SM_CYHSCROLL     = 3;
SM_CYCAPTION     = 4;
SM_CXBORDER      = 5;
SM_CYBORDER      = 6;
SM_CXDLGFRAME    = 7;
SM_CYDLGFRAME    = 8;
SM_CYVTHUMB      = 9;
SM_CXHTHUMB      = 10;
SM_CXICON        = 11;
SM_CYICON        = 12;
SM_CXCURSOR      = 13;
SM_CYCURSOR      = 14;
SM_CYMENU        = 15;
SM_CXFULLSCREEN  = 16;
SM_CYFULLSCREEN  = 17;
SM_CYKANJIWINDOW = 18;
SM_MOUSEPRESENT  = 19;
SM_CYVSCROLL     = 20;
SM_CXHSCROLL     = 21;
SM_DEBUG         = 22;
SM_SWAPBUTTON    = 23;
SM_RESERVED1     = 24;
SM_RESERVED2     = 25;
SM_RESERVED3     = 26;
SM_RESERVED4     = 27;
SM_CXMIN         = 28;
SM_CYMIN         = 29;
SM_CXSIZE        = 30;
SM_CYSIZE        = 31;
SM_CXFRAME       = 32;
SM_CYFRAME       = 33;
SM_CXMINTRACK    = 34;
SM_CYMINTRACK    = 35;
SM_CXDOUBLECLK   = 36;
SM_CYDOUBLECLK   = 37;
SM_CXICONSPACING = 38;
SM_CYICONSPACING = 39;
SM_MENUDROPALIGNMENT = 40;
SM_PENWINDOWS    = 41;
SM_DBCSENABLED   = 42;
SM_CMOUSEBUTTONS = 43;
SM_CXFIXEDFRAME  = SM_CXDLGFRAME;
SM_CYFIXEDFRAME  = SM_CYDLGFRAME;
SM_CXSIZEFRAME   = SM_CXFRAME;
SM_CYSIZEFRAME   = SM_CYFRAME;
SM_SECURE        = 44;
SM_CXEDGE        = 45;
SM_CYEDGE        = 46;
SM_CXMINSPACING  = 47;
SM_CYMINSPACING  = 48;
SM_CXSMICON      = 49;
SM_CYSMICON      = 50;
SM_CYSMCAPTION   = 51;
SM_CXSMSIZE      = 52;
SM_CYSMSIZE      = 53;
SM_CXMENUSIZE    = 54;
SM_CYMENUSIZE    = 55;
SM_ARRANGE       = 56;
SM_CXMINIMIZED   = 57;
SM_CYMINIMIZED   = 58;
SM_CXMAXTRACK    = 59;
SM_CYMAXTRACK    = 60;
SM_CXMAXIMIZED   = 61;
SM_CYMAXIMIZED   = 62;
SM_NETWORK       = 63;
SM_CLEANBOOT     = 67;
SM_CXDRAG        = 68;
SM_CYDRAG        = 69;
SM_SHOWSOUNDS    = 70;
SM_CXMENUCHECK   = 71;
SM_CYMENUCHECK   = 72;
SM_SLOWMACHINE   = 73;
SM_MIDEASTENABLED = 74;
SM_MOUSEWHEELPRESENT = 75;
SM_XVIRTUALSCREEN = 76;
SM_YVIRTUALSCREEN = 77;
SM_CXVIRTUALSCREEN = 78;
SM_CYVIRTUALSCREEN = 79;
SM_CMONITORS     = 80;
SM_SAMEDISPLAYFORMAT = 81;
SM_IMMENABLED    = 82;
SM_CXFOCUSBORDER = 83;
SM_CYFOCUSBORDER = 84;
SM_TABLETPC      = 86;
SM_MEDIACENTER   = 87;
SM_STARTER       = 88;
SM_SERVERR2      = 89;
SM_MOUSEHORIZONTALWHEELPRESENT = 91;
SM_CXPADDEDBORDER = 92;
SM_CMETRICS      = 93;
SM_REMOTESESSION = 0x1000;
SM_SHUTTINGDOWN  = 0x2000;
SM_REMOTECONTROL = 0x2001;
SM_CARETBLINKINGENABLED = 0x2002;

FCIDM_MENU_FILE  = 0x8000;
FCIDM_MENU_EDIT  = 0x8040;
FCIDM_MENU_VIEW  = 0x8080;
FCIDM_MENU_TOOLS = 0x80C0;
FCIDM_MENU_HELP  = 0x8100;
FCIDM_MENU_FAVORITES = 0x8170;

GWL_STYLE       = -16;
GWL_EXSTYLE     = -20;
GWLP_WNDPROC    = -4;
GWLP_HINSTANCE  = -6;
GWLP_HWNDPARENT = -8;
GWLP_USERDATA   = -21;
GWLP_ID         = -12;

GCLP_MENUNAME      = -8;
GCLP_HBRBACKGROUND = -10;
GCLP_HCURSOR       = -12;
GCLP_HICON         = -14;
GCLP_HMODULE       = -16;
GCLP_WNDPROC       = -24;
GCLP_HICONSM       = -34;

SPI_GETICONTITLELOGFONT = 0x001F;
SPI_GETNONCLIENTMETRICS = 0x0029;

DI_MASK        = 0x0001;
DI_IMAGE       = 0x0002;
DI_NORMAL      = 0x0003;
DI_COMPAT      = 0x0004;
DI_DEFAULTSIZE = 0x0008;
DI_NOMIRROR    = 0x0010;

FILE_SHARE_READ   = 0x00000001;
FILE_SHARE_WRITE  = 0x00000002;
FILE_SHARE_DELETE = 0x00000004;

FILE_ATTRIBUTE_READONLY            = 0x00000001;
FILE_ATTRIBUTE_HIDDEN              = 0x00000002;
FILE_ATTRIBUTE_SYSTEM              = 0x00000004;
FILE_ATTRIBUTE_DIRECTORY           = 0x00000010;
FILE_ATTRIBUTE_ARCHIVE             = 0x00000020;
FILE_ATTRIBUTE_DEVICE              = 0x00000040;
FILE_ATTRIBUTE_NORMAL              = 0x00000080;
FILE_ATTRIBUTE_TEMPORARY           = 0x00000100;
FILE_ATTRIBUTE_SPARSE_FILE         = 0x00000200;
FILE_ATTRIBUTE_REPARSE_POINT       = 0x00000400;
FILE_ATTRIBUTE_COMPRESSED          = 0x00000800;
FILE_ATTRIBUTE_OFFLINE             = 0x00001000;
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 0x00002000;
FILE_ATTRIBUTE_ENCRYPTED           = 0x00004000;
FILE_ATTRIBUTE_VIRTUAL             = 0x00010000;

SHGFI_ICON              = 0x00000100;
SHGFI_DISPLAYNAME       = 0x00000200;
SHGFI_TYPENAME          = 0x00000400;
SHGFI_ATTRIBUTES        = 0x00000800;
SHGFI_ICONLOCATION      = 0x00001000;
SHGFI_EXETYPE           = 0x00002000;
SHGFI_SYSICONINDEX      = 0x00004000;
SHGFI_LINKOVERLAY       = 0x00008000;
SHGFI_SELECTED          = 0x00010000;
SHGFI_ATTR_SPECIFIED    = 0x00020000;
SHGFI_LARGEICON         = 0x00000000;
SHGFI_SMALLICON         = 0x00000001;
SHGFI_OPENICON          = 0x00000002;
SHGFI_SHELLICONSIZE     = 0x00000004;
SHGFI_PIDL              = 0x00000008;
SHGFI_USEFILEATTRIBUTES = 0x00000010;
SHGFI_ADDOVERLAYS       = 0x00000020;
SHGFI_OVERLAYINDEX      = 0x00000040;

OFN_READONLY             = 0x00000001;
OFN_OVERWRITEPROMPT      = 0x00000002;
OFN_HIDEREADONLY         = 0x00000004;
OFN_NOCHANGEDIR          = 0x00000008;
OFN_SHOWHELP             = 0x00000010;
OFN_ENABLEHOOK           = 0x00000020;
OFN_ENABLETEMPLATE       = 0x00000040;
OFN_ENABLETEMPLATEHANDLE = 0x00000080;
OFN_NOVALIDATE           = 0x00000100;
OFN_ALLOWMULTISELECT     = 0x00000200;
OFN_EXTENSIONDIFFERENT   = 0x00000400;
OFN_PATHMUSTEXIST        = 0x00000800;
OFN_FILEMUSTEXIST        = 0x00001000;
OFN_CREATEPROMPT         = 0x00002000;
OFN_SHAREAWARE           = 0x00004000;
OFN_NOREADONLYRETURN     = 0x00008000;
OFN_NOTESTFILECREATE     = 0x00010000;
OFN_NONETWORKBUTTON      = 0x00020000;
OFN_NOLONGNAMES          = 0x00040000;
OFN_EXPLORER             = 0x00080000;
OFN_NODEREFERENCELINKS   = 0x00100000;
OFN_LONGNAMES            = 0x00200000;
OFN_ENABLEINCLUDENOTIFY  = 0x00400000;
OFN_ENABLESIZING         = 0x00800000;
OFN_DONTADDTORECENT      = 0x02000000;
OFN_FORCESHOWHIDDEN      = 0x10000000;

DBT_APPYBEGIN            = 0x0000;
DBT_APPYEND              = 0x0001;
DBT_DEVNODES_CHANGED     = 0x0007;
DBT_QUERYCHANGECONFIG    = 0x0017;
DBT_CONFIGCHANGED        = 0x0018;
DBT_CONFIGCHANGECANCELED = 0x0019;
DBT_MONITORCHANGE        = 0x001B;
DBT_SHELLLOGGEDON        = 0x0020;
DBT_CONFIGMGAPI32        = 0x0022;
DBT_VXDINITCOMPLETE      = 0x0023;
DBT_DEVICEARRIVAL           = 0x8000;
DBT_DEVICEQUERYREMOVE       = 0x8001;
DBT_DEVICEQUERYREMOVEFAILED = 0x8002;
DBT_DEVICEREMOVEPENDING     = 0x8003;
DBT_DEVICEREMOVECOMPLETE    = 0x8004;
DBT_DEVICETYPESPECIFIC      = 0x8005;
DBT_CUSTOMEVENT             = 0x8006;
DBT_VOLLOCKQUERYLOCK     = 0x8041;
DBT_VOLLOCKLOCKTAKEN     = 0x8042;
DBT_VOLLOCKLOCKFAILED    = 0x8043;
DBT_VOLLOCKQUERYUNLOCK   = 0x8044;
DBT_VOLLOCKLOCKRELEASED  = 0x8045;
DBT_VOLLOCKUNLOCKFAILED  = 0x8046;

WS_OVERLAPPED   = 0x00000000;
WS_POPUP        = Ox80000000;
WS_CHILD        = 0x40000000;
WS_MINIMIZE     = 0x20000000;
WS_VISIBLE      = 0x10000000;
WS_DISABLED     = 0x08000000;
WS_CLIPSIBLINGS = 0x04000000;
WS_CLIPCHILDREN = 0x02000000;
WS_MAXIMIZE     = 0x01000000;
WS_CAPTION      = 0x00C00000;
WS_BORDER       = 0x00800000;
WS_DLGFRAME     = 0x00400000;
WS_VSCROLL      = 0x00200000;
WS_HSCROLL      = 0x00100000;
WS_SYSMENU      = 0x00080000;
WS_THICKFRAME   = 0x00040000;
WS_GROUP        = 0x00020000;
WS_TABSTOP      = 0x00010000;

WS_MINIMIZEBOX  = 0x00020000;
WS_MAXIMIZEBOX  = 0x00010000;

SC_SIZE         = 0xF000;
SC_MOVE         = 0xF010;
SC_MINIMIZE     = 0xF020;
SC_MAXIMIZE     = 0xF030;
SC_NEXTWINDOW   = 0xF040;
SC_PREVWINDOW   = 0xF050;
SC_CLOSE        = 0xF060;
SC_VSCROLL      = 0xF070;
SC_HSCROLL      = 0xF080;
SC_MOUSEMENU    = 0xF090;
SC_KEYMENU      = 0xF100;
SC_ARRANGE      = 0xF110;
SC_RESTORE      = 0xF120;
SC_TASKLIST     = 0xF130;
SC_SCREENSAVE   = 0xF140;
SC_HOTKEY       = 0xF150;
SC_DEFAULT      = 0xF160;
SC_MONITORPOWER = 0xF170;
SC_CONTEXTHELP  = 0xF180;
SC_SEPARATOR    = 0xF00F;

NIN_SELECT           = (WM_USER + 0)
NINF_KEY             = 0x1
NIN_KEYSELECT        = (NIN_SELECT | NINF_KEY)
NIN_BALLOONSHOW      = (WM_USER + 2)
NIN_BALLOONHIDE      = (WM_USER + 3)
NIN_BALLOONTIMEOUT   = (WM_USER + 4)
NIN_BALLOONUSERCLICK = (WM_USER + 5)
NIN_POPUPOPEN        = (WM_USER + 6)
NIN_POPUPCLOSE       = (WM_USER + 7)

NIM_ADD        = 0x00;
NIM_MODIFY     = 0x01;
NIM_DELETE     = 0x02;
NIM_SETFOCUS   = 0x03;
NIM_SETVERSION = 0x04;

NIF_MESSAGE  = 0x01
NIF_ICON     = 0x02
NIF_TIP      = 0x04
NIF_STATE    = 0x08
NIF_INFO     = 0x10
NIF_GUID     = 0x20
NIF_REALTIME = 0x40
NIF_SHOWTIP  = 0x80

OBM_CLOSE = 32754;
OBM_UPARROWI = 32737;
OBM_UPARROW = 32753;
OBM_DNARROWI = 32736;
OBM_DNARROW = 32752;
OBM_RGARROWI = 32735;
OBM_RGARROW = 32751;
OBM_LFARROWI = 32734;
OBM_LFARROW = 32750;
OBM_REDUCE = 32749;
OBM_SIZE = 32766;
OBM_ZOOM = 32748;
OBM_RESTORE = 32747;
OBM_REDUCED = 32746;
OBM_ZOOMD = 32745;
OBM_RESTORED = 32744;
OBM_BTSIZE = 32761;
OBM_UPARROWD = 32743;
OBM_CHECK = 32760;
OBM_DNARROWD = 32742;
OBM_CHECKBOXES = 32759;
OBM_RGARROWD = 32741;
OBM_BTNCORNERS = 32758;
OBM_LFARROWD = 32740;
OBM_MNARROW = 32739;
OBM_COMBO = 32738;

PS_SOLID = 0;
PS_DASH = 1;
PS_DOT = 2;
PS_DASHDOT = 3;
PS_DASHDOTDOT = 4;
PS_NULL = 5;
PS_INSIDEFRAME = 6;

RDW_INVALIDATE      = 0x0001;
RDW_INTERNALPAINT   = 0x0002;
RDW_ERASE           = 0x0004;

RDW_VALIDATE        = 0x0008;
RDW_NOINTERNALPAINT = 0x0010;
RDW_NOERASE         = 0x0020;

RDW_NOCHILDREN      = 0x0040;
RDW_ALLCHILDREN     = 0x0080;

RDW_UPDATENOW       = 0x0100;
RDW_ERASENOW        = 0x0200;

RDW_FRAME           = 0x0400;
RDW_NOFRAME         = 0x0800;

SEE_MASK_ICON           = 0x00000010;
SEE_MASK_HOTKEY         = 0x00000020;
SEE_MASK_NOCLOSEPROCESS = 0x00000040;
SEE_MASK_CONNECTNETDRV  = 0x00000080;
SEE_MASK_NOASYNC        = 0x00000100;
SEE_MASK_DOENVSUBST     = 0x00000200;
SEE_MASK_FLAG_NO_UI     = 0x00000400;
SEE_MASK_UNICODE        = 0x00004000;
SEE_MASK_NO_CONSOLE     = 0x00008000;
SEE_MASK_ASYNCOK        = 0x00100000;

CMIC_MASK_HOTKEY     = SEE_MASK_HOTKEY;
CMIC_MASK_ICON       = SEE_MASK_ICON;
CMIC_MASK_FLAG_NO_UI = SEE_MASK_FLAG_NO_UI;
CMIC_MASK_UNICODE    = SEE_MASK_UNICODE;
CMIC_MASK_NO_CONSOLE = SEE_MASK_NO_CONSOLE;

CC_RGBINIT              = 0x00000001;
CC_FULLOPEN             = 0x00000002;
CC_PREVENTFULLOPEN      = 0x00000004;
CC_SHOWHELP             = 0x00000008;
CC_ENABLEHOOK           = 0x00000010;
CC_ENABLETEMPLATE       = 0x00000020;
CC_ENABLETEMPLATEHANDLE = 0x00000040;
CC_SOLIDCOLOR           = 0x00000080;
CC_ANYCOLOR             = 0x00000100;

CDB2GVF_SHOWALLFILES = 0x00000001;
CDB2GVF_NOSELECTVERB = 0x00000008;

CONTEXT_MENU_DEFAULT = 0;
CONTEXT_MENU_IMAGE = 1;
CONTEXT_MENU_CONTROL = 2;
CONTEXT_MENU_TABLE = 3;
CONTEXT_MENU_TEXTSELECT = 4;
CONTEXT_MENU_ANCHOR = 5;
CONTEXT_MENU_UNKNOWN = 6;
CONTEXT_MENU_IMGDYNSRC = 7;
CONTEXT_MENU_IMGART = 8;
CONTEXT_MENU_DEBUG = 9;
CONTEXT_MENU_VSCROLL = 10;
CONTEXT_MENU_HSCROLL = 11;

MIIM_STATE      = 0x00000001;
MIIM_ID         = 0x00000002;
MIIM_SUBMENU    = 0x00000004;
MIIM_CHECKMARKS = 0x00000008;
MIIM_TYPE       = 0x00000010;
MIIM_DATA       = 0x00000020;
MIIM_STRING     = 0x00000040;
MIIM_BITMAP     = 0x00000080;
MIIM_FTYPE      = 0x00000100;

HBMMENU_CALLBACK         = -1;
HBMMENU_SYSTEM           =  1;
HBMMENU_MBAR_RESTORE     =  2;
HBMMENU_MBAR_MINIMIZE    =  3;
HBMMENU_MBAR_CLOSE       =  5;
HBMMENU_MBAR_CLOSE_D     =  6;
HBMMENU_MBAR_MINIMIZE_D  =  7;
HBMMENU_POPUP_CLOSE      =  8;
HBMMENU_POPUP_RESTORE    =  9;
HBMMENU_POPUP_MAXIMIZE   = 10;
HBMMENU_POPUP_MINIMIZE   = 11;

CommandID_EXIT       = 3;
CommandID_LINK       = 17;
CommandID_DELETE     = 18;
CommandID_RENAME     = 19;
CommandID_PROPERTIES = 20;
CommandID_CUT        = 25;
CommandID_COPY       = 26;
CommandID_PASTE      = 27;

ICON_SMALL  = 0;
ICON_BIG    = 1;
ICON_SMALL2 = 2;

adTypeBinary = 1;
adTypeText = 2;
adLF = 10;
adCR = 13;
adCRLF = -1;
adWriteChar = 0;
adWriteLine = 1;
adSaveCreateNotExist = 1;
adSaveCreateOverWrite = 2;
adReadAll = -1;
adReadLine = -2;

MB_OK                = 0x0000;
MB_OKCANCEL          = 0x0001;
MB_ABORTRETRYIGNORE  = 0x0002;
MB_YESNOCANCEL       = 0x0003;
MB_YESNO             = 0x0004;
MB_RETRYCANCEL       = 0x0005;
MB_CANCELTRYCONTINUE = 0x0006;

MB_ICONSTOP          = 0x0010;
MB_ICONQUESTION      = 0x0020;
MB_ICONEXCLAMATION   = 0x0030;
MB_ICONINFORMATION   = 0x0040;
MB_USERICON          = 0x0080;

MB_DEFBUTTON1        = 0x0000;
MB_DEFBUTTON2        = 0x0100;
MB_DEFBUTTON3        = 0x0200;
MB_DEFBUTTON4        = 0x0300;

MB_APPLMODAL            = 0x00000000;
MB_SYSTEMMODAL          = 0x00001000;
MB_TASKMODAL            = 0x00002000;
MB_NOFOCUS              = 0x00008000;
MB_SETFOREGROUND        = 0x00010000;
MB_DEFAULT_DESKTOP_ONLY = 0x00020000;
MB_TOPMOST              = 0x00040000;
MB_RIGHT                = 0x00080000;
MB_RTLREADING           = 0x00100000;

IDOK       = 1;
IDCANCEL   = 2;
IDABORT    = 3;
IDRETRY    = 4;
IDIGNORE   = 5;
IDYES      = 6;
IDNO       = 7;
IDCLOSE    = 8;
IDHELP     = 9;
IDTRYAGAIN = 10;
IDCONTINUE = 11;

GW_HWNDFIRST    = 0;
GW_HWNDLAST     = 1;
GW_HWNDNEXT     = 2;
GW_HWNDPREV     = 3;
GW_OWNER        = 4;
GW_CHILD        = 5;
GW_ENABLEDPOPUP = 6;

SYNCHRONIZE = 0x00100000;
STANDARD_RIGHTS_REQUIRED = 0x000F0000;

PROCESS_TERMINATE                 = 0x0001;
PROCESS_CREATE_THREAD             = 0x0002;
PROCESS_SET_SESSIONID             = 0x0004;
PROCESS_VM_OPERATION              = 0x0008;
PROCESS_VM_READ                   = 0x0010;
PROCESS_VM_WRITE                  = 0x0020;
PROCESS_DUP_HANDLE                = 0x0040;
PROCESS_CREATE_PROCESS            = 0x0080;
PROCESS_SET_QUOTA                 = 0x0100;
PROCESS_SET_INFORMATION           = 0x0200;
PROCESS_QUERY_INFORMATION         = 0x0400;
PROCESS_SUSPEND_RESUME            = 0x0800;
PROCESS_QUERY_LIMITED_INFORMATION = 0x1000;
PROCESS_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFF;

MOUSEEVENTF_MOVE        = 0x0001;
MOUSEEVENTF_LEFTDOWN    = 0x0002;
MOUSEEVENTF_LEFTUP      = 0x0004;
MOUSEEVENTF_RIGHTDOWN   = 0x0008;
MOUSEEVENTF_RIGHTUP     = 0x0010;
MOUSEEVENTF_MIDDLEDOWN  = 0x0020;
MOUSEEVENTF_MIDDLEUP    = 0x0040;
MOUSEEVENTF_XDOWN       = 0x0080;
MOUSEEVENTF_XUP         = 0x0100;
MOUSEEVENTF_WHEEL       = 0x0800;
MOUSEEVENTF_HWHEEL      = 0x01000;
MOUSEEVENTF_MOVE_NOCOALESCE = 0x2000;
MOUSEEVENTF_VIRTUALDESK = 0x4000;
MOUSEEVENTF_ABSOLUTE    = 0x8000;

INFINITE = 0xFFFFFFFF;

WAIT_OBJECT_0  = 0x0000;
WAIT_ABANDONED = 0x0080;
WAIT_TIMEOUT   = 0x0102;

QS_KEY            = 0x0001;
QS_MOUSEMOVE      = 0x0002;
QS_MOUSEBUTTON    = 0x0004;
QS_POSTMESSAGE    = 0x0008;
QS_TIMER          = 0x0010;
QS_PAINT          = 0x0020;
QS_SENDMESSAGE    = 0x0040;
QS_HOTKEY         = 0x0080;
QS_ALLPOSTMESSAGE = 0x0100;
QS_RAWINPUT       = 0x0400;
QS_MOUSE = QS_MOUSEMOVE | QS_MOUSEBUTTON;
QS_INPUT = QS_MOUSE | QS_KEY | QS_RAWINPUT;
QS_ALLEVENTS = QS_INPUT | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_HOTKEY;
QS_ALLINPUT = QS_INPUT | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_HOTKEY | QS_SENDMESSAGE;

PM_NOREMOVE = 0x0000;
PM_REMOVE   = 0x0001;
PM_NOYIELD  = 0x0002;
PM_QS_INPUT = (QS_INPUT << 16);
PM_QS_POSTMESSAGE = ((QS_POSTMESSAGE | QS_HOTKEY | QS_TIMER) << 16);
PM_QS_PAINT = (QS_PAINT << 16);
PM_QS_SENDMESSAGE = (QS_SENDMESSAGE << 16);

MNC_IGNORE  = 0;
MNC_CLOSE   = 1;
MNC_EXECUTE = 2;
MNC_SELECT  = 3;

SFGAO_CANCOPY         = DROPEFFECT_COPY;
SFGAO_CANMOVE         = DROPEFFECT_MOVE;
SFGAO_CANLINK         = DROPEFFECT_LINK;
SFGAO_STORAGE         = 0x00000008;
SFGAO_CANRENAME       = 0x00000010;
SFGAO_CANDELETE       = 0x00000020;
SFGAO_HASPROPSHEET    = 0x00000040;
SFGAO_DROPTARGET      = 0x00000100;
SFGAO_CAPABILITYMASK  = 0x00000177;
SFGAO_SYSTEM          = 0x00001000;
SFGAO_ENCRYPTED       = 0x00002000;
SFGAO_ISSLOW          = 0x00004000;
SFGAO_GHOSTED         = 0x00008000;
SFGAO_LINK            = 0x00010000;
SFGAO_SHARE           = 0x00020000;
SFGAO_READONLY        = 0x00040000;
SFGAO_HIDDEN          = 0x00080000;
SFGAO_DISPLAYATTRMASK = 0x000FC000;
SFGAO_FILESYSANCESTOR = 0x10000000;
SFGAO_FOLDER          = 0x20000000;
SFGAO_FILESYSTEM      = 0x40000000;
SFGAO_HASSUBFOLDER    = Ox80000000;
SFGAO_CONTENTSMASK    = Ox80000000;
SFGAO_VALIDATE        = 0x01000000;
SFGAO_REMOVABLE       = 0x02000000;
SFGAO_COMPRESSED      = 0x04000000;
SFGAO_BROWSABLE       = 0x08000000;
SFGAO_NONENUMERATED   = 0x00100000;
SFGAO_NEWCONTENT      = 0x00200000;
SFGAO_CANMONIKER      = 0x00400000;
SFGAO_HASSTORAGE      = 0x00400000;
SFGAO_STREAM          = 0x00400000;
SFGAO_STORAGEANCESTOR = 0x00800000;
SFGAO_STORAGECAPMASK  = 0x70C50008;
SFGAO_PKEYSFGAOMASK   = api.LowPart(0x81044000);

GCS_VERB     = 0x00000004;
GCS_HELPTEXT = 0x00000005;
GCS_VALIDATE = 0x00000006;
GCS_VERBICON = 0x00000014;

HKEY_CLASSES_ROOT                = 0x80000000;
HKEY_CURRENT_USER                = 0x80000001;
HKEY_LOCAL_MACHINE               = 0x80000002;
HKEY_USERS                       = 0x80000003;
HKEY_PERFORMANCE_DATA            = 0x80000004;
HKEY_PERFORMANCE_TEXT            = 0x80000050;
HKEY_PERFORMANCE_NLSTEXT         = 0x80000060;
HKEY_CURRENT_CONFIG              = 0x80000005;
HKEY_CURRENT_USER_LOCAL_SETTINGS = 0x80000007;

SHERB_NOCONFIRMATION = 0x00000001;
SHERB_NOPROGRESSUI   = 0x00000002;
SHERB_NOSOUND        = 0x00000004;

KEYEVENTF_EXTENDEDKEY = 0x0001;
KEYEVENTF_KEYUP       = 0x0002;
KEYEVENTF_UNICODE     = 0x0004;
KEYEVENTF_SCANCODE    = 0x0008;

ASSOCF_NONE                 = 0x00000000;
ASSOCF_INIT_NOREMAPCLSID    = 0x00000001;
ASSOCF_INIT_BYEXENAME       = 0x00000002;
ASSOCF_OPEN_BYEXENAME       = 0x00000002;
ASSOCF_INIT_DEFAULTTOSTAR   = 0x00000004;
ASSOCF_INIT_DEFAULTTOFOLDER = 0x00000008;
ASSOCF_NOUSERSETTINGS       = 0x00000010;
ASSOCF_NOTRUNCATE           = 0x00000020;
ASSOCF_VERIFY               = 0x00000040;
ASSOCF_REMAPRUNDLL          = 0x00000080;
ASSOCF_NOFIXUPS             = 0x00000100;
ASSOCF_IGNOREBASECLASS      = 0x00000200;
ASSOCF_INIT_IGNOREUNKNOWN   = 0x00000400;
ASSOCF_INIT_FIXED_PROGID    = 0x00000800;
ASSOCF_IS_PROTOCOL          = 0x00001000;
ASSOCF_INIT_FOR_FILE        = 0x00002000;

ASSOCSTR_COMMAND = 1;
ASSOCSTR_EXECUTABLE = 2;
ASSOCSTR_FRIENDLYDOCNAME = 3;
ASSOCSTR_FRIENDLYAPPNAME = 4;
ASSOCSTR_NOOPEN = 5;
ASSOCSTR_SHELLNEWVALUE = 6;
ASSOCSTR_DDECOMMAND = 7;
ASSOCSTR_DDEIFEXEC = 8;
ASSOCSTR_DDEAPPLICATION = 9;
ASSOCSTR_DDETOPIC = 10;
ASSOCSTR_INFOTIP = 11;
ASSOCSTR_QUICKTIP = 12;
ASSOCSTR_TILEINFO = 13;
ASSOCSTR_CONTENTTYPE = 14;
ASSOCSTR_DEFAULTICON = 15;
ASSOCSTR_SHELLEXTENSION = 16;
ASSOCSTR_DROPTARGET = 17;
ASSOCSTR_DELEGATEEXECUTE = 18;
ASSOCSTR_SUPPORTED_URI_PROTOCOLS = 19;

SHIL_LARGE = 0;
SHIL_SMALL = 1;
SHIL_EXTRALARGE = 2;
SHIL_SYSSMALL = 3;
SHIL_JUMBO = 4;

system32 = api.GetDisplayNameOf(ssfSYSTEM, SHGDN_FORPARSING);

// GDI Plus
RotateNoneFlipNone = 0;
Rotate90FlipNone   = 1;
Rotate180FlipNone  = 2;
Rotate270FlipNone  = 3;

RotateNoneFlipX    = 4;
Rotate90FlipX      = 5;
Rotate180FlipX     = 6;
Rotate270FlipX     = 7;

RotateNoneFlipY    = Rotate180FlipX;
Rotate90FlipY      = Rotate270FlipX;
Rotate180FlipY     = RotateNoneFlipX;
Rotate270FlipY     = Rotate90FlipX;

RotateNoneFlipXY   = Rotate180FlipNone;
Rotate90FlipXY     = Rotate270FlipNone;
Rotate180FlipXY    = RotateNoneFlipNone;
Rotate270FlipXY    = Rotate90FlipNone;

EncoderValueColorTypeCMYK = 0;
EncoderValueColorTypeYCCK = 1;
EncoderValueCompressionLZW = 2;
EncoderValueCompressionCCITT3 = 3;
EncoderValueCompressionCCITT4 = 4;
EncoderValueCompressionRle = 5;
EncoderValueCompressionNone = 6;
EncoderValueScanMethodInterlaced = 7;
EncoderValueScanMethodNonInterlaced = 8;
EncoderValueVersionGif87 = 9;
EncoderValueVersionGif89 = 10;
EncoderValueRenderProgressive = 11;
EncoderValueRenderNonProgressive = 12;
EncoderValueTransformRotate90 = 13;
EncoderValueTransformRotate180 = 14;
EncoderValueTransformRotate270 = 15;
EncoderValueTransformFlipHorizontal = 16;
EncoderValueTransformFlipVertical = 17;
EncoderValueMultiFrame = 18;
EncoderValueLastFrame = 19;
EncoderValueFlush = 20;
EncoderValueFrameDimensionTime = 21;
EncoderValueFrameDimensionResolution = 22;
EncoderValueFrameDimensionPage = 23;
EncoderValueColorTypeGray = 24;
EncoderValueColorTypeRGB = 25;

EncoderColorDepth     = "{66087055-ad66-4c7c-9a18-38a2310b8337}";
EncoderQuality        = "{1d5be4b5-fa4a-452d-9cdd-5db35105e7eb}";
EncoderTransformation = "{8d0eb2d1-a58e-4ea8-aa14-108074b7b6f9}";

EncoderParameterValueTypeByte           = 1;
EncoderParameterValueTypeASCII          = 2;
EncoderParameterValueTypeShort          = 3;
EncoderParameterValueTypeLong           = 4;
EncoderParameterValueTypeRational       = 5;
EncoderParameterValueTypeLongRange      = 6;
EncoderParameterValueTypeUndefined      = 7;
EncoderParameterValueTypeRationalRange  = 8;
EncoderParameterValueTypePointer        = 9;
